/*
 * 著作権: Copyright (c) 2007－2008 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ext.s2jdbc.wizards;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;

public class TableCellModifier2 implements ICellModifier {

    protected TableViewer viewer;

    protected Object oldValue = null;

    protected Object newValue = null;

    public TableCellModifier2(TableViewer viewer) {
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        int index = Integer.parseInt(property);
        if (index == 0 || index == 1)
            return false;

        return true;
    }

    public Object getValue(Object element, String property) {
        int index = Integer.parseInt(property);// 数値に変換
        if (element instanceof FormProperty) {
            FormProperty fp = (FormProperty) element;
            return fp.getValue(index);
        }
        return null;

    }

    public void modify(Object element, String property, Object value) {
        int index = Integer.parseInt(property);
        if (element instanceof Item) {
            Object o = ((Item) element).getData();
            if (o instanceof FormProperty) {
                FormProperty fp = (FormProperty) o;
                fp.setValue(index, String.valueOf(value));
                viewer.update(fp, new String[] { property });
            }
        }

    }
}
